IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_BALAN_IT_CHECKOUT]') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_BALAN] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[QT_IT] [money] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[FLAG_SOBREPOR] [int] NOT NULL,
	[FLAG_SOMAR] [int] NOT NULL,
	[FLAG_ACUMULAR] [int] NOT NULL,
 CONSTRAINT [PK_EST_PROD_BALAN_IT_CHECKOUT] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_CD_BALAN]  DEFAULT ((0)) FOR [CD_BALAN]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_QT_IT]  DEFAULT ((0)) FOR [QT_IT]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_FLAG_SOBREPOR]  DEFAULT ((0)) FOR [FLAG_SOBREPOR]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_FLAG_SOMAR]  DEFAULT ((0)) FOR [FLAG_SOMAR]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] ADD  CONSTRAINT [DF_EST_PROD_BALAN_IT_CHECKOUT_FLAG_ACUMULAR]  DEFAULT ((0)) FOR [FLAG_ACUMULAR]

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_BALAN_IT_CHECKOUT_EST_PROD_BALAN] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_BALAN])
REFERENCES [dbo].[EST_PROD_BALAN] ([CD_EMP], [CD_FILIAL], [CD_BALAN])

ALTER TABLE [dbo].[EST_PROD_BALAN_IT_CHECKOUT] CHECK CONSTRAINT [FK_EST_PROD_BALAN_IT_CHECKOUT_EST_PROD_BALAN]
END